import sys
import os
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from abyss_text import abyss_print, abyss_input, AbyssColors, set_theme
import socket
import ssl
import time
import random
from urllib.parse import urlparse

# Import the deep_port_scan function
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from deep_port_scan import deep_port_scan, VULNERABLE_PORTS

def ftp_anonymous_login(ip, port=21, n=1):
    """Attempt anonymous FTP login"""
    abyss_print(f"[FTP ATTACK] Attempting anonymous login...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((ip, port))
            
            # Receive banner
            banner = sock.recv(1024).decode('utf-8', errors='ignore')
            abyss_print(f"  └─ Banner: {banner.strip()}", color=AbyssColors.VOID_WHITE)
            
            # Try anonymous login
            sock.send(b"USER anonymous\r\n")
            response = sock.recv(1024).decode('utf-8', errors='ignore')
            abyss_print(f"  └─ USER response: {response.strip()}", color=AbyssColors.VOID_WHITE)
            
            sock.send(b"PASS anonymous@example.com\r\n")
            response = sock.recv(1024).decode('utf-8', errors='ignore')
            
            if "230" in response:
                abyss_print(f"  └─ ✓ CRITICAL: Anonymous FTP access granted!", 
                           color=AbyssColors.NEON_RED,
                           outline_char="heavy")
            else:
                abyss_print(f"  └─ Login failed: {response.strip()}", 
                           color=AbyssColors.BRIGHT_YELLOW)
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def ssh_banner_grab(ip, port=22, n=1):
    """SSH banner grabbing and version detection"""
    abyss_print(f"[SSH ATTACK] Banner grabbing...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((ip, port))
            
            banner = sock.recv(1024).decode('utf-8', errors='ignore').strip()
            abyss_print(f"  └─ SSH Banner: {banner}", color=AbyssColors.NEON_GREEN)
            
            # Check for known vulnerable versions
            vulnerable_versions = ['OpenSSH_7.4', 'OpenSSH_6', 'OpenSSH_5']
            for vuln in vulnerable_versions:
                if vuln in banner:
                    abyss_print(f"  └─ ⚠ Potentially vulnerable version detected!", 
                               color=AbyssColors.NEON_RED)
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def telnet_exploit(ip, port=23, n=1):
    """Telnet connection attempt"""
    abyss_print(f"[TELNET ATTACK] Attempting connection...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((ip, port))
            
            response = sock.recv(1024).decode('utf-8', errors='ignore')
            abyss_print(f"  └─ ✓ CRITICAL: Telnet is open (unencrypted)!", 
                       color=AbyssColors.NEON_RED,
                       outline_char="heavy")
            abyss_print(f"  └─ Response: {response.strip()}", color=AbyssColors.VOID_WHITE)
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def http_attack(ip, port=80, n=1):
    """HTTP enumeration and vulnerability scanning"""
    abyss_print(f"[HTTP ATTACK] Probing web server...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((ip, port))
            
            # Send HTTP request
            request = f"HEAD / HTTP/1.1\r\nHost: {ip}\r\nConnection: close\r\n\r\n"
            sock.send(request.encode())
            
            response = sock.recv(4096).decode('utf-8', errors='ignore')
            
            # Extract server header
            for line in response.split('\r\n'):
                if line.startswith('Server:'):
                    abyss_print(f"  └─ {line}", color=AbyssColors.NEON_GREEN)
                if line.startswith('X-Powered-By:'):
                    abyss_print(f"  └─ {line}", color=AbyssColors.NEON_GREEN)
            
            # Check for common vulnerabilities
            if 'Apache/2.4.49' in response or 'Apache/2.4.50' in response:
                abyss_print(f"  └─ ⚠ Known vulnerable Apache version!", 
                           color=AbyssColors.NEON_RED)
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def https_attack(ip, port=443, n=1):
    """HTTPS/SSL enumeration"""
    abyss_print(f"[HTTPS ATTACK] SSL/TLS probing...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            context = ssl.create_default_context()
            context.check_hostname = False
            context.verify_mode = ssl.CERT_NONE
            
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            
            ssl_sock = context.wrap_socket(sock, server_hostname=ip)
            ssl_sock.connect((ip, port))
            
            # Get certificate info
            cert = ssl_sock.getpeercert()
            cipher = ssl_sock.cipher()
            
            abyss_print(f"  └─ SSL/TLS Version: {ssl_sock.version()}", 
                       color=AbyssColors.NEON_GREEN)
            abyss_print(f"  └─ Cipher: {cipher[0]}", color=AbyssColors.VOID_WHITE)
            
            # Check for weak ciphers
            weak_ciphers = ['RC4', 'DES', 'MD5']
            for weak in weak_ciphers:
                if weak in str(cipher):
                    abyss_print(f"  └─ ⚠ Weak cipher detected!", 
                               color=AbyssColors.NEON_RED)
            
            ssl_sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def smb_attack(ip, port=445, n=1):
    """SMB enumeration"""
    abyss_print(f"[SMB ATTACK] Probing SMB service...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((ip, port))
            
            abyss_print(f"  └─ ✓ CRITICAL: SMB port open (ransomware vector)!", 
                       color=AbyssColors.NEON_RED,
                       outline_char="heavy")
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def rdp_attack(ip, port=3389, n=1):
    """RDP enumeration"""
    abyss_print(f"[RDP ATTACK] Probing Remote Desktop...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((ip, port))
            
            abyss_print(f"  └─ ✓ CRITICAL: RDP exposed (remote takeover risk)!", 
                       color=AbyssColors.NEON_RED,
                       outline_char="heavy")
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def sql_attack(ip, port, db_type="MySQL", n=1):
    """Database server probing"""
    abyss_print(f"[{db_type.upper()} ATTACK] Probing database...", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((ip, port))
            
            # Try to grab banner
            banner = sock.recv(1024)
            if banner:
                abyss_print(f"  └─ Banner: {banner[:100].decode('utf-8', errors='ignore')}", 
                           color=AbyssColors.NEON_GREEN)
            
            abyss_print(f"  └─ ⚠ {db_type} exposed to internet!", 
                       color=AbyssColors.NEON_RED)
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def generic_port_attack(ip, port, description, n=1):
    """Generic port probing"""
    abyss_print(f"[PORT {port} ATTACK] {description}", 
                color=AbyssColors.NEON_CYAN)
    
    for i in range(n):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(3)
            sock.connect((ip, port))
            
            # Try to grab banner
            try:
                sock.send(b"\r\n")
                banner = sock.recv(1024).decode('utf-8', errors='ignore')
                if banner.strip():
                    abyss_print(f"  └─ Banner: {banner.strip()[:100]}", 
                               color=AbyssColors.NEON_GREEN)
            except:
                pass
            
            abyss_print(f"  └─ Port {port} is open and responding", 
                       color=AbyssColors.BRIGHT_YELLOW)
            
            sock.close()
        except Exception as e:
            abyss_print(f"  └─ Attack failed: {e}", color=AbyssColors.BRIGHT_RED)

def execute_targeted_attacks(ip, scan_results, n=1):
    """Execute attacks based on open ports discovered"""
    
    if not scan_results:
        abyss_print("No open ports found. Cannot proceed with attacks.", 
                   color=AbyssColors.BRIGHT_RED)
        return
    
    abyss_print(f"\n◢ INITIATING VOIDSTRIKE PROTOCOL ◣\nTarget: {ip}\nOpen Ports: {len(scan_results)}", 
                color=AbyssColors.NEON_RED,
                outline_char="heavy",
                padding=1)
    
    print("\n")
    
    # Attack each discovered port
    for result in scan_results:
        port = result['port']
        desc = result['description']
        
        print("\n")
        abyss_print(f"═══ ATTACKING PORT {port} ═══", 
                   color=AbyssColors.BOLD + AbyssColors.NEON_RED)
        print()
        
        # Route to specific attack based on port
        if port == 21:
            ftp_anonymous_login(ip, port, n)
        elif port == 22:
            ssh_banner_grab(ip, port, n)
        elif port == 23:
            telnet_exploit(ip, port, n)
        elif port in [80, 8080]:
            http_attack(ip, port, n)
        elif port == 443:
            https_attack(ip, port, n)
        elif port == 445:
            smb_attack(ip, port, n)
        elif port == 3389:
            rdp_attack(ip, port, n)
        elif port == 3306:
            sql_attack(ip, port, "MySQL", n)
        elif port == 1433:
            sql_attack(ip, port, "MSSQL", n)
        elif port == 5432:
            sql_attack(ip, port, "PostgreSQL", n)
        else:
            generic_port_attack(ip, port, desc, n)
        
        time.sleep(0.5)  # Small delay between attacks
    
    print("\n")
    abyss_print("═══ VOIDSTRIKE COMPLETE ═══", 
                color=AbyssColors.BOLD + AbyssColors.NEON_GREEN,
                outline_char="double",
                padding=1)

def main():
    set_theme("red")
    
    abyss_print("◢ VOIDSTRIKE ◣\nAUTOMATED EXPLOIT ENGINE", 
                outline_char="double",
                padding=1)
    
    print("\n")
    
    abyss_print("VOIDSTRIKE scans a target and automatically attacks discovered services.", 
                color=AbyssColors.BRIGHT_YELLOW,
                outline_char="box")
    
    print("\n")
    
    # Get target IP
    target = abyss_input("Enter target IP (default: 127.0.0.1): ", 
                        color=AbyssColors.NEON_CYAN)
    
    if not target.strip():
        target = "127.0.0.1"
    
    print("\n")
    
    # Scan type
    scan_type = abyss_input("Scan type (1: Fast, 2: Full, 3: Vulnerable only) [default: 3]: ",
                           color=AbyssColors.NEON_CYAN)
    
    if scan_type == "1":
        scan_range = range(1, 1025)
    elif scan_type == "2":
        scan_range = range(1, 65535)
    else:
        scan_range = list(VULNERABLE_PORTS.keys())
    
    print("\n")
    
    abyss_print(f"◢ PHASE 1: RECONNAISSANCE ◣\nScanning {target}...", 
                color=AbyssColors.NEON_CYAN,
                outline_char="box",
                padding=1)
    
    print("\n")
    
    # Perform port scan
    scan_results = deep_port_scan(target, scan_range, max_workers=500)
    
    print("\n")
    
    if scan_results:
        abyss_print(f"Discovered {len(scan_results)} open port(s)", 
                   color=AbyssColors.NEON_GREEN,
                   outline_char="box")
        
        # Display found ports
        for result in scan_results:
            port_info = f"Port {result['port']}: {result['description']}"
            color = AbyssColors.NEON_RED if result['vulnerable'] else AbyssColors.VOID_WHITE
            abyss_print(f"  └─ {port_info}", color=color)
    else:
        abyss_print("No open ports found.", 
                   color=AbyssColors.BRIGHT_RED,
                   outline_char="box")
        return
    
    print("\n")
    
    abyss_print("◢ PHASE 2: EXPLOITATION ◣", 
                color=AbyssColors.NEON_RED,
                outline_char="box",
                padding=1)
    

    execute_targeted_attacks(target, scan_results, n=99)

if __name__ == "__main__":
    main()
