import socket
import sys
import threading
import traceback

HOST = '0.0.0.0'
PORT = 56789
BUFFER_SIZE = 8192

def fallback_message(n):
    return f"(fallback: restricted environment - code execution blocked) {n}"

def execute_code(code):
    try:
        import io
        from contextlib import redirect_stdout, redirect_stderr
    except ImportError:
        return fallback_message(0)

    output = io.StringIO()
    error  = io.StringIO()

    try:
        local = {}
        with redirect_stdout(output), redirect_stderr(error):
            exec(code, globals(), local)
        result = output.getvalue()
        err = error.getvalue()
        if err:
            return f"stderr:\n{err}\n\n{result}"
        return result or "(no output)"
    except Exception:
        return "Exception:\n" + traceback.format_exc()

def handle_client(conn, addr):
    try:
        conn.sendall(b"ready\nsend code, finish with empty line\n\n")
        data = bytearray()
        while True:
            chunk = conn.recv(BUFFER_SIZE)
            if not chunk:
                break
            data.extend(chunk)
            if data.endswith(b'\n\n'):
                try:
                    code = data.decode('utf-8').rstrip()
                    result = execute_code(code)
                    conn.sendall(f"Result:\n{result}\n\n".encode('utf-8'))
                except:
                    conn.sendall(b"decode or exec error\n\n")
                data.clear()
            if data.endswith(b'.quit\n') or data.endswith(b'.quit\n\n'):
                conn.sendall(b"bye\n")
                break
    finally:
        try:
            conn.close()
        except:
            pass

def main():
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    try:
        s.bind((HOST, PORT))
        s.listen(5)
        print(f"listening {HOST}:{PORT}")
        while True:
            conn, addr = s.accept()
            threading.Thread(target=handle_client, args=(conn, addr), daemon=True).start()
    except KeyboardInterrupt:
        print("stopped")
    except Exception as e:
        print(f"server error: {e}")
    finally:
        s.close()

if __name__ == '__main__':
    main()