dataset = {
    'greeting': [
        "Hello! How can I assist you today?",
        "Hi there! What can I do for you?",
        "Greetings! How's your day going?",
        "Hey! What brings you here today?",
        "Hello! How can I help you?"
    ],
    'questionAboutWellBeing': [
        "How are you feeling today?",
        "Is everything going well with you?",
        "How's your day been so far?",
        "How's everything going on your end?",
        "Are you doing well today?"
    ],
    'features': [
        "I can help with answering questions, providing information, and engaging in casual conversation.",
        "I offer assistance with various topics and can chat about many things.",
        "My capabilities include providing information and interacting on a range of subjects.",
        "I can provide details on a variety of topics and assist with inquiries.",
        "I'm here to help with questions, provide info, and have interesting conversations."
    ],
    'thank_you': [
        "You're welcome! If you need anything else, feel free to ask.",
        "No problem! I'm here to help.",
        "Glad to assist! Let me know if there's more I can do.",
        "You're welcome! I'm happy to help.",
        "Anytime! If you have more questions, just ask."
    ],
    'goodbye': [
        "Goodbye! Have a great day!",
        "See you later! Take care.",
        "Farewell! If you need more help, just reach out.",
        "Bye for now! Hope to chat again soon.",
        "Take care! Have a wonderful day."
    ],
     'welcome': [
        "Welcome! How can I assist you?",
        "Glad to have you here! What can I do for you?",
        "Welcome aboard! How's it going today?",
        "Hey, welcome! What would you like to talk about?",
        "Welcome! How can I make your day better?",
        "Hello and welcome! Need help with something?",
        "Glad you're here! What brings you today?",
        "Welcome! How can I assist in making things easier?",
        "Hi, welcome! Ready for some assistance?",
        "Welcome! What can I do for you right now?"
    ],
    'adviceForStudy': [
        "Make a clear study schedule and stick to it.",
        "Break your study sessions into manageable chunks.",
        "Take regular breaks to avoid burnout while studying.",
        "Active recall and spaced repetition are great study techniques.",
        "Don’t forget to stay hydrated and eat well while studying.",
        "Find a quiet, comfortable study environment for focus.",
        "Avoid cramming; it's better to study a little every day.",
        "Review your notes soon after learning them to reinforce memory.",
        "Use past exams and questions to practice effectively.",
        "Studying with a friend can help with motivation and accountability."
    ],
    'motivation': [
        "You’ve got this! Keep pushing forward.",
        "Don’t give up, every step gets you closer to your goal.",
        "Success is the sum of small efforts, repeated day in and day out.",
        "Remember why you started; you're stronger than you think.",
        "Stay focused on your journey, and keep making progress.",
        "You are capable of amazing things, don’t underestimate yourself.",
        "Challenges are what make life interesting; overcoming them makes life meaningful.",
        "Keep going, even on tough days; every step counts.",
        "Believe in yourself and all that you are.",
        "Your hard work will pay off, just stay consistent."
    ],
    'smallTalk': [
        "The weather’s been really nice lately, hasn’t it?",
        "Seen any good movies recently?",
        "What kind of music do you like?",
        "Have any fun plans for the weekend?",
        "What’s your favorite way to relax?",
        "Do you enjoy reading? Any good book recommendations?",
        "Have you tried any new hobbies recently?",
        "What’s your favorite way to spend a rainy day?",
        "Been on any interesting trips lately?",
        "What’s your go-to comfort food?"
    ],
    'careerAdvice': [
        "Network regularly to build strong professional connections.",
        "Focus on developing both hard and soft skills.",
        "Never stop learning; continuous education is key in any career.",
        "Find a mentor who can offer guidance and advice.",
        "Always be open to constructive feedback and use it to improve.",
        "Tailor your resume and cover letter to each job application.",
        "Keep your LinkedIn profile updated with your latest achievements.",
        "Don’t be afraid to ask for opportunities or seek new challenges.",
        "Maintain a healthy work-life balance to avoid burnout.",
        "Stay persistent; every career journey has its ups and downs."
    ],
    'healthTips': [
        "Drink plenty of water to stay hydrated throughout the day.",
        "Aim for at least 7-8 hours of sleep each night.",
        "Exercise regularly to boost both physical and mental health.",
        "Incorporate more fruits and vegetables into your meals.",
        "Take breaks to stretch and move around if sitting for long periods.",
        "Practice mindfulness or meditation to reduce stress.",
        "Wash your hands frequently to prevent illness.",
        "Limit your intake of processed foods and sugars.",
        "Get outside and enjoy some fresh air whenever possible.",
        "Make time for hobbies and activities that make you happy."
    ],
    'fitnessAdvice': [
        "Consistency is key when it comes to fitness.",
        "Focus on both strength training and cardio for a balanced workout.",
        "Always warm up before exercising to prevent injuries.",
        "Set realistic fitness goals and track your progress.",
        "Remember to cool down and stretch after your workouts.",
        "Listen to your body and avoid overtraining.",
        "Incorporate rest days to allow your muscles to recover.",
        "Stay hydrated during and after your workouts.",
        "Fuel your body with nutritious foods to support your fitness routine.",
        "Try new workouts to keep your routine exciting and challenging."
    ],
    'hobbies': [
        "Learning to play a musical instrument can be very rewarding.",
        "Gardening is a great way to relax and enjoy nature.",
        "Cooking new recipes can be both fun and delicious.",
        "Photography helps you capture the beauty in everyday life.",
        "Painting or drawing is a wonderful creative outlet.",
        "Hiking is a great way to stay fit while exploring the outdoors.",
        "Journaling can help clear your mind and track your thoughts.",
        "Building model kits can be a satisfying and focused hobby.",
        "Knitting or crocheting is a fun way to create your own clothing and accessories.",
        "Volunteering in your community is a great way to give back and meet new people."
    ],
    'productivity': [
        "Set clear goals at the start of each day.",
        "Break tasks into smaller steps to make them more manageable.",
        "Use time-blocking to stay focused and on track.",
        "Take short breaks to stay energized and avoid burnout.",
        "Eliminate distractions by turning off notifications during work.",
        "Prioritize your tasks by importance and deadline.",
        "Start with the hardest task to get it out of the way early.",
        "Use a planner or app to track your tasks and deadlines.",
        "Delegate when necessary to lighten your workload.",
        "Reward yourself for completing tasks to stay motivated."
    ],
    'relaxationTips': [
        "Try deep breathing exercises to calm your mind.",
        "Take a walk in nature to relax and clear your head.",
        "Listening to your favorite music can be very soothing.",
        "A warm bath or shower can help you unwind.",
        "Meditation can reduce stress and increase mindfulness.",
        "Reading a good book is a great way to escape and relax.",
        "Spend some time with loved ones to recharge emotionally.",
        "Practice gratitude to help shift your mindset to the positive.",
        "Light some candles or incense for a calming atmosphere.",
        "Give yourself permission to take breaks and do nothing."
    ],
    'timeManagement': [
        "Prioritize your tasks based on urgency and importance.",
        "Set aside specific times for focused work.",
        "Use the Pomodoro Technique to break work into manageable intervals.",
        "Make use of to-do lists to stay organized.",
        "Plan your day the night before to start with clear intentions.",
        "Avoid multitasking and focus on one task at a time.",
        "Use a timer to keep yourself on track and avoid distractions.",
        "Group similar tasks together to work more efficiently.",
        "Learn to say no to commitments that don’t align with your goals.",
        "Regularly review and adjust your time management strategies."
    ],
    'selfCare': [
        "Make time each day for activities that bring you joy.",
        "Take care of your body with regular exercise and good nutrition.",
        "Prioritize sleep to help your body and mind recharge.",
        "Set boundaries to protect your time and energy.",
        "Practice mindfulness or meditation to stay present.",
        "Be kind to yourself and practice self-compassion.",
        "Spend time with people who uplift and support you.",
        "Do things that make you laugh; humor is great for the soul.",
        "Take breaks from technology to recharge mentally.",
        "Don’t be afraid to ask for help when you need it."
    ],
    'teamWork': [
        "Good communication is the foundation of strong teamwork.",
        "Respect and appreciate everyone’s contributions to the team.",
        "Work towards a common goal, keeping the team's objectives in mind.",
        "Be open to feedback and constructive criticism.",
        "Collaborate and brainstorm to come up with better ideas.",
        "Support and encourage your teammates when they face challenges.",
        "Clear delegation of tasks helps to avoid confusion.",
        "Celebrate successes and recognize each other’s hard work.",
        "Stay flexible and be willing to adjust plans as needed.",
        "Fostering trust within a team leads to better collaboration."
    ],
    'lifeGoals': [
        "Set both short-term and long-term goals to stay motivated.",
        "Break your goals down into actionable steps.",
        "Visualize your goals regularly to keep them at the forefront of your mind.",
        "Stay flexible and be willing to adjust your goals as needed.",
        "Celebrate small wins along the way to stay motivated.",
        "Surround yourself with people who support your dreams.",
        "Focus on progress, not perfection, as you work towards your goals.",
        "Regularly reflect on your goals and evaluate your progress.",
        "Create a vision board to inspire and motivate you.",
        "Don’t be afraid to dream big; believe in your potential."
    ],
    'creativity': [
        "Don’t be afraid to experiment and try new things.",
        "Step outside your comfort zone to spark creativity.",
        "Take time to observe the world around you for inspiration.",
        "Keep a journal of your creative ideas and thoughts.",
        "Collaborating with others can fuel your creativity.",
        "Use limitations as opportunities to think outside the box.",
        "Don’t strive for perfection, just focus on creating.",
        "Embrace mistakes as part of the creative process.",
        "Set aside time each day for creative activities.",
        "Expose yourself to new experiences to keep your creativity flowing."
    ],
    'learning': [
        "Stay curious and never stop seeking knowledge.",
        "Read books, articles, and other materials to expand your mind.",
        "Take online courses or attend workshops to learn new skills.",
        "Engage in discussions and debates to broaden your perspective.",
        "Teach others what you know to reinforce your own learning.",
        "Challenge yourself with new topics and ideas.",
        "Seek out mentors who can guide you in your learning journey.",
        "Experiment with different learning methods to find what works best for you.",
        "Stay open-minded and be willing to learn from anyone.",
        "Remember that learning is a lifelong journey."
    ],
       'positiveAffirmations': [
        "You are capable of achieving great things.",
        "You are stronger than you realize.",
        "Believe in yourself, and you will go far.",
        "You are worthy of love and respect.",
        "Every day is a new opportunity to grow.",
        "You are resilient and can overcome challenges.",
        "You are enough just as you are.",
        "Your hard work will pay off, stay focused.",
        "You bring value to the world in your own unique way.",
        "Keep shining; your light inspires others."
    ],
    'publicSpeakingTips': [
        "Practice your speech multiple times to build confidence.",
        "Know your audience and tailor your message to them.",
        "Start with a strong opening to capture attention.",
        "Use pauses to emphasize key points and give yourself time to think.",
        "Maintain eye contact with different parts of the audience.",
        "Keep your body language open and positive.",
        "Speak clearly and at a steady pace.",
        "Prepare for possible questions and know your material well.",
        "Use storytelling to make your points more relatable.",
        "End your speech with a clear and memorable takeaway."
    ],
    'personalFinance': [
        "Create a monthly budget to track your income and expenses.",
        "Build an emergency fund for unexpected expenses.",
        "Avoid unnecessary debt and pay off high-interest debt first.",
        "Start saving early for retirement to take advantage of compound interest.",
        "Invest in diversified assets to reduce risk.",
        "Monitor your credit score regularly to ensure it stays healthy.",
        "Set financial goals and track your progress.",
        "Live below your means to save for the future.",
        "Review your subscriptions and cancel those you don't use.",
        "Consider automating your savings to build wealth consistently."
    ],
    'mentalHealth': [
        "It’s okay to take breaks and rest when you need to.",
        "Don’t hesitate to seek help when you’re feeling overwhelmed.",
        "Journaling can help you process your emotions.",
        "Meditation and mindfulness can improve your mental clarity.",
        "Talking to a friend or therapist can ease your burdens.",
        "Recognize your emotions and allow yourself to feel them.",
        "Set boundaries to protect your mental well-being.",
        "Practice gratitude daily to shift your mindset.",
        "Engage in activities that make you feel happy and fulfilled.",
        "Prioritize self-care and make time for yourself."
    ],
    'interviewTips': [
        "Research the company before your interview to show interest.",
        "Practice common interview questions to prepare your responses.",
        "Dress appropriately for the role you’re interviewing for.",
        "Arrive early to show punctuality and reliability.",
        "Maintain good posture and make eye contact with the interviewer.",
        "Listen carefully to the questions before answering.",
        "Be concise and stay on topic when responding to questions.",
        "Prepare questions to ask the interviewer about the company or role.",
        "Highlight your strengths and provide examples of your achievements.",
        "Follow up with a thank-you note after the interview."
    ],
    'parentingTips': [
        "Spend quality time with your children to strengthen your bond.",
        "Set clear and consistent boundaries for behavior.",
        "Be a role model; children often mimic their parents.",
        "Praise your children for their efforts, not just achievements.",
        "Encourage open communication and listen to your child’s feelings.",
        "Stay patient, parenting is a journey of learning for both of you.",
        "Teach your children the value of empathy and kindness.",
        "Be involved in their education and support their interests.",
        "Provide a safe and loving environment for growth.",
        "Remember, it's okay to ask for help when you need it."
    ],
    'workplaceEtiquette': [
        "Be punctual and respect other people’s time.",
        "Communicate clearly and professionally with colleagues.",
        "Stay organized to meet deadlines and manage tasks efficiently.",
        "Respect your coworkers' space and boundaries.",
        "Be open to feedback and use it to improve your work.",
        "Dress appropriately for your workplace environment.",
        "Keep personal conversations and distractions to a minimum.",
        "Offer help when your colleagues need assistance.",
        "Keep a positive attitude and contribute to a collaborative environment.",
        "Handle conflicts calmly and professionally."
    ],
    'goalSetting': [
        "Set SMART goals: Specific, Measurable, Achievable, Relevant, and Time-bound.",
        "Break larger goals into smaller, manageable steps.",
        "Review your progress regularly and adjust your goals as needed.",
        "Stay motivated by celebrating small wins along the way.",
        "Keep your goals visible to remind yourself of what you’re working towards.",
        "Make sure your goals align with your values and priorities.",
        "Stay flexible and be open to adjusting your goals if necessary.",
        "Stay accountable by sharing your goals with someone you trust.",
        "Use a vision board to visualize your goals and stay inspired.",
        "Set deadlines to create urgency and maintain focus."
    ],
    'confidenceBuilding': [
        "Celebrate your successes, no matter how small.",
        "Focus on your strengths and skills rather than your weaknesses.",
        "Challenge yourself to step out of your comfort zone.",
        "Surround yourself with positive, supportive people.",
        "Don’t compare yourself to others; focus on your own journey.",
        "Practice positive self-talk to boost your confidence.",
        "Take care of your physical health; it affects your mental state.",
        "Learn from your mistakes and use them as growth opportunities.",
        "Face your fears one step at a time to build resilience.",
        "Set realistic goals and acknowledge your progress."
    ],
    'languageLearning': [
        "Practice speaking the language daily, even if it’s just for a few minutes.",
        "Listen to music, podcasts, or watch shows in the language you’re learning.",
        "Join language exchange groups or find a language partner.",
        "Use language learning apps to practice vocabulary and grammar.",
        "Don’t be afraid to make mistakes, they’re part of the learning process.",
        "Set small goals, like learning five new words each day.",
        "Immerse yourself in the culture of the language you’re learning.",
        "Practice writing short sentences or journal entries in the language.",
        "Label objects around your home with their names in the new language.",
        "Use flashcards to reinforce your vocabulary learning."
    ],
    'cookingTips': [
        "Always read the recipe thoroughly before starting.",
        "Season your food as you cook, not just at the end.",
        "Use fresh herbs and spices for better flavor.",
        "Let meat rest after cooking to retain its juices.",
        "Taste your food as you cook to adjust seasoning.",
        "Clean as you go to keep your kitchen organized.",
        "Use a sharp knife for more efficient and safer cutting.",
        "Preheat your oven or pan for better cooking results.",
        "Experiment with different ingredients to discover new flavors.",
        "Measure ingredients accurately for consistent results."
    ],
    'travelTips': [
        "Pack light to make traveling easier and more convenient.",
        "Always have a backup of important documents, like your passport.",
        "Learn a few key phrases in the local language.",
        "Stay hydrated and bring snacks for long journeys.",
        "Be flexible with your plans to embrace spontaneous experiences.",
        "Research local customs and traditions before your trip.",
        "Use apps to navigate and find local hotspots.",
        "Make sure your accommodations have secure storage for valuables.",
        "Travel insurance is essential for unexpected situations.",
        "Respect local culture and be mindful of your surroundings."
    ],
    'jobHunting': [
        "Tailor your resume to each job you apply for.",
        "Use LinkedIn to connect with professionals in your industry.",
        "Prepare for interviews by practicing common questions.",
        "Keep learning and improving your skills to stay competitive.",
        "Follow up on job applications if you haven’t heard back.",
        "Research the company before going into an interview.",
        "Don’t be discouraged by rejection; keep applying.",
        "Network with industry professionals to open new opportunities.",
        "Use job search platforms to find relevant job postings.",
        "Be proactive and apply for jobs even if you’re unsure of the outcome."
    ],
    'nutritionTips': [
        "Incorporate a variety of fruits and vegetables into your meals.",
        "Stay hydrated by drinking plenty of water throughout the day.",
        "Choose whole grains over refined grains for more nutrients.",
        "Limit processed foods and opt for fresh, natural ingredients.",
        "Balance your meals with protein, carbohydrates, and healthy fats.",
        "Snack on nuts, seeds, or fruits instead of sugary snacks.",
        "Meal prep in advance to make healthier choices during the week.",
        "Avoid skipping meals to maintain consistent energy levels.",
        "Pay attention to portion sizes to avoid overeating.",
        "Moderation is key; treat yourself occasionally without overindulging."
    ],
    'personalDevelopment': [
        "Identify your strengths and areas for improvement.",
        "Set personal goals and work towards them daily.",
        "Take time for self-reflection and journaling.",
        "Read books or take courses to learn new skills.",
        "Surround yourself with people who inspire and challenge you.",
        "Be open to new experiences that push you outside your comfort zone.",
        "Practice gratitude to foster a positive mindset.",
        "Take constructive feedback as a learning opportunity.",
        "Stay consistent in your efforts to see growth.",
        "Celebrate your progress and milestones along the way."
    ],
    'mindfulness': [
        "Take a few moments each day to focus on your breathing.",
        "Practice gratitude by reflecting on things you're thankful for.",
        "Stay present and avoid distractions during daily tasks.",
        "Engage in activities like yoga or meditation to center yourself.",
        "Use mindful eating to savor each bite and enjoy your food.",
        "Observe your thoughts without judgment, just let them pass.",
        "Spend time in nature to ground yourself and clear your mind.",
        "Be aware of your emotions and accept them without resistance.",
        "Create a calm environment for yourself, free from noise and clutter.",
        "Make time for self-care to recharge and maintain balance."
    ],
    'relationshipAdvice': [
        "Communication is key to a strong and healthy relationship.",
        "Show appreciation for your partner regularly.",
        "Respect your partner’s boundaries and personal space.",
        "Spend quality time together to strengthen your bond.",
        "Support each other’s goals and aspirations.",
        "Practice active listening and be present in conversations.",
        "Compromise is essential for resolving conflicts peacefully.",
        "Be honest and transparent about your feelings.",
        "Apologize sincerely when you’re wrong and take responsibility.",
        "Celebrate each other’s achievements and milestones together."
    ],
    'timeManagement': [
        "Prioritize tasks based on their importance and deadlines.",
        "Break larger tasks into smaller steps to make them manageable.",
        "Use a planner or digital tool to track your daily schedule.",
        "Set specific time blocks for focused work without distractions.",
        "Take regular breaks to avoid burnout and stay productive.",
        "Review your progress at the end of each day or week.",
        "Avoid multitasking and focus on one task at a time.",
        "Set boundaries to protect your time from unnecessary interruptions.",
        "Delegate tasks when possible to lighten your workload.",
        "Learn to say no to commitments that don’t align with your goals."
    ],
'pythonBasics': [
        "Python is an interpreted, high-level programming language known for its simplicity.",
        "Python uses indentation to define code blocks, replacing the need for braces.",
        "Variables in Python don’t need explicit declaration of data types.",
        "Use the `print()` function to display output in Python.",
        "Lists in Python are ordered, mutable collections that can store multiple items.",
        "A dictionary in Python stores key-value pairs for efficient lookups.",
        "Use loops like `for` and `while` to iterate over collections or repeat code blocks.",
        "Functions in Python are defined using the `def` keyword followed by the function name.",
        "Use the `if-elif-else` construct for conditional execution of code.",
        "Python supports object-oriented programming with classes and inheritance.",
        "List comprehensions provide a concise way to create lists in Python.",
        "Python has a rich standard library with modules like `os`, `math`, and `datetime`.",
        "Use the `import` statement to include external modules or libraries in your code.",
        "The `try-except` block is used for error handling in Python.",
        "You can read and write files in Python using the `open()` function.",
        "Python supports both mutable and immutable data types, like lists (mutable) and tuples (immutable).",
        "Use `range()` to generate a sequence of numbers, often used with loops.",
        "Generators allow lazy iteration of values using the `yield` keyword.",
        "Use the `with` statement to handle resources like file operations more cleanly.",
        "Python supports lambda functions, which are anonymous, one-line functions.",
        "Decorators are used to modify or extend the behavior of functions or methods.",
        "Python has built-in support for working with JSON data using the `json` module.",
        "List slicing allows you to access parts of a list using `start:end:step` syntax.",
        "Python has built-in support for complex numbers, useful in scientific computing.",
        "Python’s `Pandas` library is widely used for data analysis and manipulation."
    ],
    'javaBasics': [
        "Java is a class-based, object-oriented programming language designed to have fewer implementation dependencies.",
        "Java programs are compiled into bytecode that can run on any platform with a Java Virtual Machine (JVM).",
        "The `public static void main(String[] args)` method is the entry point for a Java application.",
        "Java uses curly braces `{}` to define code blocks.",
        "Variables in Java must be declared with a specific data type, such as `int`, `double`, or `String`.",
        "Java arrays are fixed in size and must have their type declared, like `int[]` for an integer array.",
        "Java supports loops like `for`, `while`, and `do-while` for iteration.",
        "The `if-else` statement in Java allows for conditional execution of code blocks.",
        "Java is a strongly-typed language, meaning variable types are checked at compile-time.",
        "Java classes are the blueprint for creating objects, which are instances of the class.",
        "Inheritance in Java allows a class to inherit properties and methods from another class.",
        "Java interfaces define a contract for methods that implementing classes must follow.",
        "Use the `try-catch` block for exception handling in Java.",
        "Java has a garbage collector that automatically manages memory for unused objects.",
        "You can define multiple methods with the same name (overloading) but different parameter types or counts.",
        "Java supports multithreading, allowing concurrent execution of tasks using the `Thread` class.",
        "The `ArrayList` class in Java provides dynamic arrays that can grow or shrink in size.",
        "Use `HashMap` to store key-value pairs for fast lookup and retrieval.",
        "Java supports access modifiers like `public`, `private`, and `protected` to control the visibility of class members.",
        "The `Scanner` class is commonly used for taking input from the user.",
        "Java supports lambda expressions for writing anonymous methods more concisely.",
        "Use the `synchronized` keyword to ensure thread-safe access to resources.",
        "Java's `String` class is immutable, meaning once a `String` is created, it cannot be modified.",
        "You can create custom exceptions in Java by extending the `Exception` class.",
        "Java has a large standard library, including APIs for networking, file I/O, and concurrency."
    ],
    'javascriptBasics': [
        "JavaScript is a versatile, high-level programming language primarily used for web development.",
        "Variables in JavaScript can be declared using `var`, `let`, or `const`.",
        "Functions in JavaScript can be declared using the `function` keyword or as arrow functions (`=>`).",
        "JavaScript objects are collections of key-value pairs and can be created using object literals.",
        "JavaScript arrays are dynamic and can hold multiple data types.",
        "JavaScript uses prototypes for inheritance rather than classes, although ES6 introduced `class` syntax.",
        "The `document` object allows interaction with the DOM (Document Object Model) of a webpage.",
        "JavaScript events like `onclick` and `onload` are used to handle user interactions.",
        "JavaScript is a dynamically-typed language, meaning variables don’t need a declared type.",
        "Promises in JavaScript are used for handling asynchronous operations.",
        "JavaScript supports `if-else` statements for conditional execution of code.",
        "Use the `for`, `while`, and `do-while` loops for iteration in JavaScript.",
        "JavaScript supports closures, where functions can retain access to variables from their scope.",
        "The `this` keyword refers to the object in which the function is executed.",
        "JavaScript has template literals, allowing embedded expressions with backticks (` `).",
        "Arrow functions in JavaScript have a lexical binding of `this`.",
        "JavaScript has built-in support for JSON data manipulation using `JSON.stringify()` and `JSON.parse()`.",
        "JavaScript uses `try-catch` blocks for error handling.",
        "Event bubbling and capturing allow for managing how events propagate through the DOM.",
        "The `fetch` API is used for making network requests in modern JavaScript.",
        "JavaScript modules allow code to be organized and reused across files using `import` and `export`.",
        "The `map()`, `filter()`, and `reduce()` methods are used for processing arrays.",
        "JavaScript can be executed both in the browser and on the server using Node.js.",
        "JavaScript is non-blocking, meaning it can handle asynchronous tasks without halting execution.",
        "Use the `localStorage` and `sessionStorage` objects to store data in the browser."
    ],
    'csharpBasics': [
        "C# (C-sharp) is a modern, object-oriented programming language developed by Microsoft.",
        "C# uses curly braces `{}` to define code blocks.",
        "The `Main()` method is the entry point of a C# program.",
        "Variables in C# must be declared with a specific type, like `int`, `string`, or `bool`.",
        "C# supports both value types (like `int`, `float`) and reference types (like `objects`).",
        "C# uses `for`, `while`, and `do-while` loops for iteration.",
        "The `if-else` statement is used for conditional execution in C#.",
        "Classes in C# are blueprints for creating objects, supporting object-oriented principles.",
        "C# supports properties, which are a special kind of class member for accessing private fields.",
        "Inheritance in C# allows a class to inherit from a base class, extending its functionality.",
        "C# interfaces define contracts that implementing classes must follow.",
        "Use the `try-catch` block for exception handling in C#.",
        "The `List<T>` class provides dynamic arrays in C#, where `T` represents the type of items.",
        "C# supports LINQ (Language Integrated Query) for querying collections in a declarative way.",
        "The `delegate` keyword in C# is used to define method pointers.",
        "C# events are based on delegates and are used for implementing event-driven programming.",
        "Use the `using` statement for resource management and to ensure objects are disposed of properly.",
        "C# has nullable types, allowing value types to represent null values using `?`, like `int?`.",
        "C# supports async programming with the `async` and `await` keywords.",
        "The `StringBuilder` class is used for efficient string manipulation in C#.",
        "C# supports generic classes and methods, allowing for type-safe code reuse.",
        "The `Dictionary<TKey, TValue>` class provides a way to store key-value pairs in C#.",
        "C# enums represent a set of named constants.",
        "The `Task` class in C# is used for managing asynchronous operations.",
        "Attributes in C# provide metadata that can be attached to code elements like classes or methods."
    ],
    'cppBasics': [
        "C++ is a general-purpose programming language with object-oriented and low-level memory manipulation features.",
        "C++ uses curly braces `{}` to define code blocks.",
        "The `main()` function is the entry point of a C++ program.",
        "Variables in C++ must be declared with a specific type, like `int`, `float`, or `char`.",
        "C++ allows the use of pointers to directly manipulate memory addresses.",
        "C++ supports both stack and heap memory allocation using `new` and `delete` for dynamic memory management.",
        "Use loops like `for`, `while`, and `do-while` for iteration in C++.",
        "The `if-else` statement in C++ allows for conditional execution of code blocks.",
        "C++ supports function overloading, where multiple functions can have the same name but different parameters.",
        "C++ classes encapsulate data and methods, supporting object-oriented principles like encapsulation and inheritance.",
        "C++ allows operator overloading, enabling custom behavior for operators in user-defined types.",
        "Inheritance in C++ allows a class to inherit properties and methods from another class.",
        "The `try-catch` block is used for exception handling in C++.",
        "Use `std::vector` in C++ to create dynamic arrays that grow in size as needed.",
        "C++ supports templates, allowing functions and classes to operate with generic types.",
        "C++ allows for multiple inheritance, where a class can inherit from more than one base class.",
        "C++ namespaces are used to organize code and prevent name collisions.",
        "The `std::map` class in C++ provides an ordered collection of key-value pairs.",
        "C++ supports smart pointers (`std::shared_ptr`, `std::unique_ptr`) to manage dynamic memory more safely.",
        "Use the `inline` keyword in C++ to suggest that a function's code should be inserted at its call site.",
        "C++ supports function pointers, allowing functions to be passed as arguments or stored in variables.",
        "C++ has support for lambda expressions, which are anonymous functions that can capture variables from their scope.",
        "The `friend` keyword in C++ allows a function or class to access private and protected members of another class.",
        "C++ has strong support for low-level programming with direct access to memory and hardware.",
        "C++ allows for constant member functions, which promise not to modify the object they belong to."
    ],
    'rubyBasics': [
        "Ruby is a dynamic, object-oriented programming language known for its simplicity and productivity.",
        "Ruby uses `do` and `end` or curly braces `{}` to define code blocks.",
        "The `puts` method is used to output text in Ruby.",
        "Variables in Ruby do not need explicit declaration of data types.",
        "Ruby symbols are lightweight identifiers often used as keys in hashes.",
        "Ruby arrays are ordered, indexed collections of objects.",
        "Ruby hashes are collections of key-value pairs, similar to dictionaries in other languages.",
        "Use loops like `for`, `while`, and `each` for iteration in Ruby.",
        "The `if-else` statement in Ruby allows for conditional execution of code blocks.",
        "Ruby classes are blueprints for creating objects, supporting object-oriented principles.",
        "Inheritance in Ruby allows a class to inherit properties and methods from another class.",
        "Ruby modules provide namespaces and mixins for code reuse and organization.",
        "Use the `rescue` block for exception handling in Ruby.",
        "Ruby symbols are immutable and unique, often used as identifiers or keys.",
        "Ruby blocks are chunks of code that can be passed to methods for execution.",
        "Ruby lambdas are anonymous functions that can be stored in variables and passed around.",
        "The `each_with_index` method in Ruby iterates over a collection with the index of each element.",
        "Ruby supports metaprogramming, allowing programs to modify themselves at runtime.",
        "Use the `require` statement to include external libraries or modules in your Ruby code.",
        "Ruby’s `Enumerable` module provides a rich set of methods for working with collections.",
        "Ruby’s `String` class has many built-in methods for text manipulation and formatting.",
        "Use the `yield` keyword to pass control from a method to a block.",
        "Ruby’s `File` class provides methods for reading from and writing to files.",
        "Ruby’s `Time` class is used for working with dates and times in Ruby programs.",
        "Ruby’s `Regexp` class provides powerful pattern matching capabilities for string manipulation."
    ],
    'phpBasics': [
        "PHP is a server-side scripting language designed for web development.",
        "PHP code is embedded within HTML, typically enclosed in `<?php ?>` tags.",
        "Variables in PHP start with a dollar sign (`$`) followed by the variable name.",
        "PHP arrays can store multiple values and are created using the `array()` function.",
        "PHP supports associative arrays, where keys are mapped to values for efficient lookups.",
        "Use loops like `for`, `while`, and `foreach` for iteration in PHP.",
        "The `if-else` statement in PHP allows for conditional execution of code blocks.",
        "PHP functions are defined using the `function` keyword followed by the function name.",
        "PHP classes are used to create objects and support object-oriented programming principles.",
        "Inheritance in PHP allows a class to inherit properties and methods from another class.",
        "PHP interfaces define a contract for methods that implementing classes must follow.",
        "Use the `try-catch` block for exception handling in PHP.",
        "PHP supports namespaces for organizing code and preventing naming conflicts.",
        "The `include` and `require` statements are used to include external PHP files.",
        "PHP’s `$_GET` and `$_POST` superglobals are used to retrieve form data submitted via GET and POST methods.",
        "PHP’s `$_SESSION` superglobal is used to store session data across multiple pages.",
        "Use the `mysqli` or `PDO` extension in PHP for interacting with databases.",
        "PHP supports cookies for storing small pieces of data on the client-side.",
        "The `echo` statement is used to output text or variables in PHP.",
        "PHP’s `date()` function is used for formatting dates and times.",
        "Use the `file_get_contents()` function to read the contents of a file into a string.",
        "PHP’s `json_encode()` and `json_decode()` functions are used for working with JSON data.",
        "PHP’s `mail()` function is used to send email messages from a PHP script.",
        "PHP’s `header()` function is used to send raw HTTP headers from a PHP script."
    ],
     'htmlBasics': [
        "HTML stands for HyperText Markup Language and is used to structure content on the web.",
        "An HTML document is composed of elements represented by tags, like `<html>`, `<head>`, and `<body>`.",
        "The `<head>` element contains meta-information about the document, such as the title and link to stylesheets.",
        "The `<body>` element contains the content of the document, such as text, images, and links.",
        "HTML elements can have attributes that provide additional information, like `class` or `id`.",
        "The `<a>` tag defines hyperlinks, allowing users to navigate between pages or resources.",
        "The `<img>` tag is used to embed images into an HTML document.",
        "Lists in HTML can be ordered (`<ol>`) or unordered (`<ul>`), with list items defined by `<li>` tags.",
        "Forms in HTML are created using the `<form>` element and can include various input types like text fields and buttons.",
        "Tables are created with `<table>`, `<tr>`, `<th>`, and `<td>` tags to structure tabular data.",
        "HTML5 introduced semantic elements like `<header>`, `<footer>`, `<article>`, and `<section>` for better document structure.",
        "The `<div>` tag is a generic container used for styling and layout purposes.",
        "The `<span>` tag is used for styling inline elements.",
        "HTML can include embedded scripts using the `<script>` tag, often for JavaScript.",
        "The `<style>` tag is used to include CSS directly within an HTML document.",
        "HTML attributes are added within the opening tag of an element, like `href` for links or `src` for images.",
        "Use the `<meta>` tag to specify character encoding, author, and other metadata.",
        "The `<iframe>` tag allows embedding another HTML document within the current document.",
        "HTML documents should include a `<!DOCTYPE html>` declaration at the beginning to specify the HTML version.",
        "The `<link>` tag is used to link external stylesheets to an HTML document.",
        "The `<button>` tag defines a clickable button, often used in forms or interactive content.",
        "HTML supports multimedia elements like `<audio>` and `<video>` for embedding media files.",
        "The `<svg>` tag is used for embedding Scalable Vector Graphics directly in HTML.",
        "HTML allows embedding external content using the `<embed>` and `<object>` tags.",
        "HTML documents should be well-formed and follow proper nesting of tags."
    ],
    'swiftBasics': [
        "Swift is a powerful, intuitive programming language developed by Apple for iOS, macOS, watchOS, and tvOS.",
        "Swift uses type inference, allowing you to write cleaner and more readable code.",
        "Variables in Swift are declared with `var`, while constants are declared with `let`.",
        "Swift supports optionals, which represent a variable that might have a value or be `nil`.",
        "Functions in Swift are declared using the `func` keyword, with parameter and return types specified.",
        "Swift supports object-oriented programming with classes and structures.",
        "Classes in Swift support inheritance, allowing one class to inherit properties and methods from another.",
        "Swift uses the `struct` keyword to define structures, which are value types.",
        "Swift’s `enum` type allows you to define a group of related values with a type-safe way.",
        "Control flow in Swift includes `if`, `else`, `switch`, and loops like `for-in` and `while`.",
        "Swift has built-in support for error handling using `do-catch` blocks.",
        "Use `guard` statements in Swift to exit early from a function if certain conditions are not met.",
        "Swift supports closures, which are self-contained blocks of code that can be passed around and used.",
        "The `defer` statement allows you to execute code just before the current scope exits.",
        "Swift provides extensive support for collections, including arrays, dictionaries, and sets.",
        "The `map()`, `filter()`, and `reduce()` methods are available for transforming and aggregating collections.",
        "Swift has powerful features for working with strings, including string interpolation and formatting.",
        "Use Swift’s `Property Wrappers` to add additional functionality to properties.",
        "Swift supports protocol-oriented programming, allowing you to define and conform to protocols.",
        "The `Codable` protocol is used for encoding and decoding data in Swift.",
        "Swift uses type aliases to create alternative names for existing types.",
        "The `@UIApplicationDelegateAdaptor` attribute is used to integrate UIKit with SwiftUI apps.",
        "Swift provides built-in support for concurrency with `async` and `await` keywords.",
        "Swift has support for access control with keywords like `public`, `private`, and `internal`."
    ],
    'dartBasics': [
        "Dart is a client-optimized programming language developed by Google for building mobile, web, and server applications.",
        "Dart uses a syntax similar to other C-style languages, such as JavaScript and Java.",
        "Variables in Dart are declared with `var`, `final`, or `const`, with `final` for one-time assignment and `const` for compile-time constants.",
        "Functions in Dart are defined using the `void` keyword for no return value or a specific type for a return value.",
        "Dart supports both class-based and functional programming paradigms.",
        "Classes in Dart encapsulate data and behavior, with constructors for initializing objects.",
        "Dart uses `async` and `await` for handling asynchronous operations and futures.",
        "Control flow in Dart includes `if`, `else`, `switch`, and loops like `for`, `while`, and `do-while`.",
        "Dart has built-in support for collections, including lists, sets, and maps.",
        "The `List` class in Dart represents a sequence of objects and supports various operations.",
        "The `Map` class in Dart represents key-value pairs and allows for efficient lookups.",
        "Dart supports extension methods, allowing you to add functionality to existing classes.",
        "Use the `try-catch` block for error handling and exceptions in Dart.",
        "Dart's `async` functions return a `Future`, representing a value that will be available later.",
        "Dart has support for mixins, allowing you to reuse code across multiple classes.",
        "Use the `import` statement to include external libraries or modules in Dart.",
        "Dart’s `null-safety` feature helps prevent null reference errors by enforcing nullable and non-nullable types.",
        "The `typedef` keyword in Dart allows you to create function type aliases.",
        "Dart supports named and optional parameters in functions.",
        "Use the `@override` annotation to indicate that a method is overriding a method from a superclass.",
        "Dart provides the `Future` and `Stream` classes for working with asynchronous data.",
        "The `set` keyword in Dart allows you to define a collection of unique items.",
        "Dart has a rich set of built-in libraries for tasks like HTTP requests, file I/O, and data serialization."
    ],
    'flutterBasics': [
        "Flutter is an open-source UI toolkit developed by Google for building natively compiled applications for mobile, web, and desktop from a single codebase.",
        "Flutter uses the Dart programming language to write apps.",
        "A Flutter app is composed of widgets, which are the basic building blocks of the UI.",
        "The `MaterialApp` widget is the entry point for a Flutter app, providing theming and navigation support.",
        "Flutter’s `StatelessWidget` is used for static UIs, while `StatefulWidget` is used for dynamic UIs with mutable state.",
        "Use the `build()` method in widgets to define the UI structure.",
        "Flutter’s `Container` widget is used for layout and styling, providing padding, margins, and decoration.",
        "The `Column` and `Row` widgets are used for vertical and horizontal layouts respectively.",
        "Use the `ListView` widget to create scrollable lists of items in Flutter.",
        "The `Scaffold` widget provides a high-level structure for implementing the visual layout of an app.",
        "Flutter’s `Navigator` widget manages app navigation and routing between different screens or pages.",
        "The `FutureBuilder` widget is used to handle asynchronous operations and build UIs based on their results.",
        "Flutter’s `StreamBuilder` widget builds UIs based on data from streams.",
        "Use the `GestureDetector` widget to handle user interactions such as taps, swipes, and long presses.",
        "The `Text` widget is used to display strings of text with various styling options.",
        "Flutter supports custom animations using the `Animation` and `AnimationController` classes.",
        "Use the `Padding` widget to add space around a child widget.",
        "The `SizedBox` widget allows you to create fixed-size boxes for spacing or layout purposes.",
        "Flutter provides a rich set of material and Cupertino widgets for building native-style UIs on Android and iOS respectively.",
        "The `Form` and `TextFormField` widgets are used for building and managing forms in Flutter.",
        "Use the `MediaQuery` class to get information about the device’s screen size and orientation.",
        "Flutter’s `Provider` package is commonly used for state management in Flutter apps.",
        "The `CustomPainter` widget allows you to draw custom graphics on the canvas in Flutter.",
        "Flutter’s `Drawer` widget provides a slide-in menu for navigation and additional options."
    ],
    'cssBasics': [
        "CSS stands for Cascading Style Sheets and is used to style and layout web pages.",
        "CSS rules are composed of selectors and declarations, with selectors targeting HTML elements and declarations specifying styles.",
        "Use the `color` property to set the text color of an element.",
        "The `background-color` property sets the background color of an element.",
        "CSS supports various units for sizing, including pixels (`px`), percentages (`%`), and viewport units (`vw`, `vh`).",
        "The `margin` property adds space around elements, while `padding` adds space inside elements.",
        "Use the `border` property to define borders around elements, including width, style, and color.",
        "CSS supports layout techniques like Flexbox and Grid for responsive design.",
        "The `display` property controls the display type of an element, such as `block`, `inline`, or `flex`.",
        "The `position` property determines how an element is positioned, with values like `static`, `relative`, `absolute`, and `fixed`.",
        "Use the `float` property to position elements to the left or right within their container.",
        "CSS provides various text formatting properties, such as `font-family`, `font-size`, `font-weight`, and `text-align`.",
        "The `width` and `height` properties set the dimensions of an element.",
        "CSS transitions allow for smooth changes between property values over time.",
        "Use `@media` queries to apply different styles based on the device’s screen size or other characteristics.",
        "The `opacity` property controls the transparency of an element.",
        "CSS pseudo-classes like `:hover` and `:focus` are used to apply styles based on user interactions.",
        "Use the `z-index` property to control the stacking order of positioned elements.",
        "The `overflow` property controls how content is handled when it overflows its container.",
        "CSS variables (custom properties) allow you to define reusable values and apply them throughout your stylesheet.",
        "Use the `text-shadow` property to add shadows to text for visual effects.",
        "CSS supports animations with the `@keyframes` rule and the `animation` property.",
        "The `transform` property allows you to apply 2D and 3D transformations to elements."
    ],

}
